-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: farming simulator 25
PlayerPosition = {}
PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, function(self, context)
	if self.player.isOwner and not self.player:getIsInVehicle() then
        local _, actionEventId = g_inputBinding:registerActionEvent('SAVE_PLAYER_POSITION', self, PlayerPosition.SAVE_PLAYER_POSITION, false, true, false, true, nil, true)
        g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("SAVE_PLAYER_POSITION"))
        g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
        g_inputBinding:setActionEventTextVisibility(actionEventId, true)
    end
end)
function PlayerPosition:SAVE_PLAYER_POSITION()
    local player = g_localPlayer
    player.savePlayerPosition = not player.savePlayerPosition
    local value = g_i18n:getText("configuration_valueNo")
    if player.savePlayerPosition then
        value = g_i18n:getText("configuration_valueYes")
    end
	g_currentMission:showBlinkingWarning(g_i18n:getText("SAVE_PLAYER_POSITION").." [ "..value.." ]", 2000)
end
Player.load = Utils.prependedFunction(Player.load, function(self, playerData)
	if self.isServer then
		if playerData ~= nil then
			self.savePlayerPosition = true
            table.insert(playerData, self.savePlayerPosition)
		end
    end
end)
Player.saveDataToXMLFile = Utils.prependedFunction(Player.saveDataToXMLFile, function (xmlFile, playerData, baseKey)
    local player = g_playerSystem:getPlayerByUniqueId(playerData.uniqueId)
    if player ~= nil and player.savePlayerPosition and not player:getIsInVehicle() then
        playerData.spawnPositionX, playerData.spawnPositionY, playerData.spawnPositionZ = table.unpack({player:getPosition()})
        playerData.spawnYaw = player:getYaw()
    end
end)
addModEventListener(PlayerPosition)