
maxDensityHeightTypesByMap = {}
maxDensityHeightTypesByMap.debug = false

function maxDensityHeightTypesByMap:DensityMapHeightManagerLoadDensityMapHeightTypes(superFunc, xmlFile, missionInfo, baseDirectory, isBaseType)
	if type(xmlFile) ~= "table" then
		xmlFile = XMLFile.wrap(xmlFile, DensityMapHeightManager.xmlSchema)
	end
	local rootName = xmlFile:getRootName()
	if maxDensityHeightTypesByMap.debug then
		print("register densityMapHeightTypes from " .. tostring(xmlFile.filename))
	end
	self.heightTypeFirstChannel = xmlFile:getValue(rootName .. ".densityMapHeightTypes#firstChannel", self.heightTypeFirstChannel or 0)
	self.heightTypeNumChannels = Utils.getNoNil(maxDensityHeightTypesByMap.compressionChannels, xmlFile:getValue(rootName .. ".densityMapHeightTypes#numChannels", self.heightTypeNumChannels or 6))
	for _, key in xmlFile:iterator(rootName .. ".densityMapHeightTypes.densityMapHeightType") do
		self:loadDensityMapHeightTypeFromXML(xmlFile, key, isBaseType)
	end
	for _, key in xmlFile:iterator(rootName .. ".densityMapHeightTypes.freeAccessArea") do
		local x = xmlFile:getFloat(key .. "#x")
		local z = xmlFile:getFloat(key .. "#z")
		local radius = xmlFile:getFloat(key .. "#radius")
		if x ~= nil and (z ~= nil and radius ~= nil) then
			local area = self.freeAccessAreas
			table.insert(area, {
				["x"] = x,
				["z"] = z,
				["radius"] = radius
			})
		end
	end
	return true
end

function maxDensityHeightTypesByMap:mission00SetMissionInfo(missionInfo, missionDynamicInfo)
	local mapXMLFilename = Utils.getFilename(missionInfo.mapXMLFilename, self.baseDirectory)
	local xmlFile = XMLFile.load("MapXML", mapXMLFilename, Mission00.xmlSchema)
	local xmlFileHandle = xmlFile:getHandle()
	
	local mapFilename = getXMLString(xmlFileHandle, "map.filename")
	
	xmlFile1 = loadXMLFile("MapI3dXML", Utils.getFilename(mapFilename, self.baseDirectory))
	
	local i = 0

	while true do
		local key = string.format("i3D.Scene.TerrainTransformGroup.Layers.DetailLayer(%d)", i)

		if not hasXMLProperty(xmlFile1, key) then
			break
		end

		local name = getXMLString(xmlFile1, key .. "#name")
		
		if name == "terrainDetailHeight" then
			local compressionChannels = getXMLInt(xmlFile1, key .. "#compressionChannels")
			maxDensityHeightTypesByMap.compressionChannels = compressionChannels
			if maxDensityHeightTypesByMap.debug then
				print("maxHeightTypes found")
			end
			
			break
		end

		i = i + 1
	end
	
	delete(xmlFile1);
	
end


Mission00.setMissionInfo = Utils.prependedFunction(Mission00.setMissionInfo, maxDensityHeightTypesByMap.mission00SetMissionInfo)
DensityMapHeightManager.loadDensityMapHeightTypes = Utils.overwrittenFunction(DensityMapHeightManager.loadDensityMapHeightTypes, maxDensityHeightTypesByMap.DensityMapHeightManagerLoadDensityMapHeightTypes)

print("maxDensityHeightTypesByMap loaded.")