-- ============================================================================
-- AutoOpenDebug.lua - Central Debug System for AutoOpen
-- 
-- Author: GulliDeckel
-- Version: 1.1.0.0
-- 
-- Features:
-- - Centralized debug output system
-- - Category-based debug messages
-- - Settings-based enable/disable functionality
-- - Consistent formatting across all modules
-- ============================================================================

-- Debug settings
local DEBUG_PREFIX = "autoOpen: "
local DEBUG_CATEGORIES = {
    LOADING = "[LOADING]",
    TRIGGER = "[TRIGGER]", 
    SETTINGS = "[SETTINGS]",
    EVENT = "[EVENT]",
    GUI = "[GUI]",
    CORE = "[CORE]"
}

-- Helper function to check if debug is enabled via settings
local function isDebugEnabled()
    -- Do NOT allow debug before settings exist
    if not g_currentMission or not g_currentMission.autoOpen then
        return false
    end

    local debugEnabled = g_currentMission.autoOpen:getSetting("debugEnabled")

    return debugEnabled == true
end

-- Global debugPrint function (used by all other modules)
function debugPrint(message, category)
    if not isDebugEnabled() then
        return
    end
    
    -- Default category if not specified
    local cat = category or DEBUG_CATEGORIES.CORE
    
    -- Formatted output
    local output = DEBUG_PREFIX .. cat .. " " .. tostring(message)
    print(output)
end

-- Debug system information
-- debugPrint("AutoOpenDebug System loaded (Settings-Integration aktiv)", DEBUG_CATEGORIES.LOADING)